﻿//renderers
fnRenderInstrumentName = function (val, p, record) {
    var status = [
        '<span style="display: inline-block; width: 16px; height: 16px; margin-right: 5px;"></span>',
        '<span style="display: inline-block; width: 16px; height: 16px; margin-right: 5px; background: url(Images/tick.png) center center no-repeat;"></span>'
    ],
    txtdecor = [
        '#000',
        '#999'
    ];
    return status[record.data.STATUS] + '<span style="color: ' + txtdecor[record.data.STATUS] + '">' + record.data.ACRONYM + ' ' + record.data.MODULE + '</span>';
};

//listener for the row select event
fnOnSelectInstrument = function (record) {

    //checks if the clicked node is an instrument
    if (record.raw.is_instrument) {
        //reset the js object that handles the client-side of the questionnaire
        if (typeof (question) !== "undefined") {
            question.opts.customLogic = false;
            question.opts.skipPatterns = null;
            question.opts.txtMasks = null;
        }

        //set intrument tab panel status
        setTabpanelStatus(record.raw.status);

        //set the instrument data to the hidden field
        CompanyX.htxtInstrumentData.setValue(JSON.stringify(record.raw));

        //call direct method to render instrument on screen
        CompanyX.direct.INSTRUMENTS.OnSelectInstrument(record.raw, {
            complete: function () {
                //show the submit button
                CompanyX.pnlSubmitInstrument.show();
            }
        });
    }

    return;
};

//set the instruments tab panel status
setTabpanelStatus = function (iStatus) {
    if (iStatus == 1) {
        //hide form
        CompanyX.pnlInstrumentFormTab.tab.hide();

        //show report
        CompanyX.pnlInstrumentReportTab.tab.show();

        //show trend
        //CompanyX.pnlInstrumentTrendTab.tab.show();

        CompanyX.tpPatInstruments.setActiveTab(CompanyX.pnlInstrumentReportTab);
    }
    else {
        //show form
        CompanyX.pnlInstrumentFormTab.tab.show();

        //hide report
        CompanyX.pnlInstrumentReportTab.tab.hide();

        //hide trend
        //CompanyX.pnlInstrumentTrendTab.tab.hide();

        CompanyX.tpPatInstruments.setActiveTab(CompanyX.pnlInstrumentFormTab);
    }
};

var fnFeedbackAddResponses = function (title, message) {
    Ext.Msg.alert(title, message);
},

    fnSuccessAddResponses = function (result) {

        var title = "SAVED",
                message = "Responses were successfuly saved in the database!";

        if (!result.saved) {
            title = "ERROR";
            message = "There was an error while trying to write to te database.";
        }

        if (result.score_error || result.score_error_msg.length > 0) {
            title = "Scoring Error";
            message = result.score_error_msg;
        }

        if (result.saved) {
            fnAfterSubmitInstrument(result.intake_id);
        }

        fnFeedbackAddResponses(title, message);
    },

    fnFailureAddResponses = function (msg) {

        var title = "ERROR",
            message = msg;

        fnFeedbackAddResponses(title, message);
    };

var fnAfterSubmitInstrument = function (lIntakeID) {

    var selData = Ext.JSON.decode(CompanyX.htxtInstrumentData.value),

        node = CompanyX.treePatAppointments.getRootNode().findChildBy(function (ele) {
        if (typeof (ele.raw.mid) !== "undefined") {
            if (ele.raw.pw_event_module_id != null) {
                if (parseInt(ele.raw.pw_event_module_id) == parseInt(selData.pw_event_module_id)) {
                    return true;
                }
            }
        }
        return false;
    }, this, true);

    if (node) {
        node.set('iconCls', X.net.RM.getIcon('Tick'));
        node.raw.status = 1;
        node.raw.intake_id = lIntakeID;

        //load the report
        CompanyX.direct.INSTRUMENTS.GetInstrumentResponsesJSON(selData.patient_id, selData.mid, lIntakeID, {
            success: function (responses) {
                CompanyX.pnlInstrumentReport.update(responses);
                setTabpanelStatus(1);
            }
        });
    }
};
